# -*- coding: utf-8 -*-
from odoo import models, fields


class AccountMove(models.Model):
    _inherit = "account.move"

    depreciation_line_type = fields.Selection(string='Depreciation Line Type', selection=
    [('normal', 'Depreciation'),
     ('loss', 'Loss/(Gain) on Disposal'),
     ('sale', 'Sale Proceeds'),
     ('impairment', 'Impairment')])

    def _auto_create_asset(self):
        """
        core Odoo is allowing an asset to be created for a customer invoice. This logic says if any of the invoices
        being validated is an out_invoice or out_refund then exit the function
        typically for a supplier invoice purchasing an asset only one invoice at a time would be validated
        logged as issue with Odoo for fixing #2310025
        :return:
        """
        for move in self:
            if move.is_invoice() and type in ('out_invoice', 'out_refund'):
                return False
        return super(AccountMove, self)._auto_create_asset()
