# -*- coding: utf-8 -*-
import odoo.addons.decimal_precision as dp

from odoo import api, fields, models


class AccountAssetSell(models.TransientModel):
    _inherit = 'account.asset.sell'

    def _get_default_capital_account(self):
        return self.env.company.capital_gain_account.id

    asset_cost = fields.Float(string='Asset Cost', compute="_get_cost_and_bv")
    asset_bv = fields.Float(string='Asset Book Value', compute="_get_cost_and_bv")
    amount = fields.Float(string='Sale/Disposal Amount', digits=dp.get_precision('Account'))
    partner = fields.Many2one(comodel_name='res.partner', string='Sold To', related='invoice_id.partner_id')
    capital_account = fields.Many2one(comodel_name='account.account', string='Capital Gain Account',
                                      default=_get_default_capital_account)
    capital_gain = fields.Boolean(string='Capital Gain', compute='_compute_capital_gain', default=False, store=True,
                                  help="Technical field to know is there was a capital gain in the selling of the asset")

    @api.depends('asset_id')
    def _get_cost_and_bv(self):
        for record in self:
            record.asset_cost = record.asset_id.original_value
            record.asset_bv = record.asset_id.book_value

    @api.depends('asset_id', 'invoice_id', 'invoice_line_id')
    def _compute_capital_gain(self):
        for record in self:
            line = record.invoice_line_id or len(record.invoice_id.invoice_line_ids) == 1 and record.invoice_id.invoice_line_ids or self.env[
                'account.move.line']
            if record.asset_id.original_value < abs(line.balance):
                record.capital_gain = True

    @api.onchange('invoice_id', 'invoice_line_id')
    def onchange_invoice_or_line(self):
        for record in self:
            if record.invoice_line_id:
                record.amount = record.invoice_line_id.price_subtotal
            elif record.invoice_id:
                record.amount = record.invoice_id.invoice_line_ids[0].price_subtotal
            else:
                record.amount = 0.0

    # override of core - date should be accounting date so the date of any journal created for the disposal is the same date as the sale invoice
    def do_action(self):
        self.ensure_one()
        invoice_line = self.env['account.move.line'] if self.action == 'dispose' else self.invoice_line_id or self.invoice_id.invoice_line_ids
        return self.asset_id.set_to_close(invoice_line_id=invoice_line, date=invoice_line.move_id.date)
